/*
#include <stdio.h>
#include <Arduino.h>
#include <EEPROM.h>
#include <SPI.h>
#include <avr/pgmspace.h>
*/
/*#include "FT_Platform.h"
#include "FT_Hal_SPI.cpp"
#include "FT_CoPro_Cmds.cpp"
#include "Swiss.cpp"*/

/* Sample application to demonstrat FT800 primitives, widgets and customized screen shots */
#include <Wire.h>
#include "FT_Platform.h"
#include "sdcard.h"
//#include "FT_Hal_I2C.h"

#define SAMAPP_DELAY_BTW_APIS (1000)
#define SAMAPP_ENABLE_DELAY() Ft_Gpu_Hal_Sleep(SAMAPP_DELAY_BTW_APIS)
#define SAMAPP_ENABLE_DELAY_VALUE(x) Ft_Gpu_Hal_Sleep(x)

#define F16(s)        ((ft_int32_t)((s) * 65536))
#define SQ(v) (v*v)
#define MAX_MENUS 12
#define THUMBNAIL_ADDRESS (125*1024L)
#define MENU_POINTSIZE  5 // 16bit prec 
#define ANDROID_METHOD  // LOOPBACK_METHOD// ANDROID_METHOD
/* Global variables for display resolution to support various display panels */
/* Default is WQVGA - 480x272 */
ft_int16_t FT_DispWidth = 480;
ft_int16_t FT_DispHeight = 272;
ft_int16_t FT_DispHCycle =  548;
ft_int16_t FT_DispHOffset = 43;
ft_int16_t FT_DispHSync0 = 0;
ft_int16_t FT_DispHSync1 = 41;
ft_int16_t FT_DispVCycle = 292;
ft_int16_t FT_DispVOffset = 12;
ft_int16_t FT_DispVSync0 = 0;
ft_int16_t FT_DispVSync1 = 10;
ft_uint8_t FT_DispPCLK = 5;
ft_char8_t FT_DispSwizzle = 0;
ft_char8_t FT_DispPCLKPol = 1;

/* Global used for buffer optimization */
Ft_Gpu_Hal_Context_t host,*phost;


ft_uint32_t Ft_CmdBuffer_Index;
ft_uint32_t Ft_DlBuffer_Index;

#ifdef BUFFER_OPTIMIZATION
ft_uint8_t  Ft_DlBuffer[FT_DL_SIZE];
ft_uint8_t  Ft_CmdBuffer[FT_CMD_FIFO_SIZE];
#endif

ft_void_t Ft_App_WrCoCmd_Buffer(Ft_Gpu_Hal_Context_t *phost,ft_uint32_t cmd)
{
#ifdef  BUFFER_OPTIMIZATION
  /* Copy the command instruction into buffer */
  ft_uint32_t *pBuffcmd;
  pBuffcmd =(ft_uint32_t*)&Ft_CmdBuffer[Ft_CmdBuffer_Index];
  *pBuffcmd = cmd;
#endif
#ifdef ARDUINO_PLATFORM
  Ft_Gpu_Hal_WrCmd32(phost,cmd);
#endif

  /* Increment the command index */
  Ft_CmdBuffer_Index += FT_CMD_SIZE;  
}

ft_void_t Ft_App_WrDlCmd_Buffer(Ft_Gpu_Hal_Context_t *phost,ft_uint32_t cmd)
{
#ifdef BUFFER_OPTIMIZATION  
  /* Copy the command instruction into buffer */
  ft_uint32_t *pBuffcmd;
  pBuffcmd =(ft_uint32_t*)&Ft_DlBuffer[Ft_DlBuffer_Index];
  *pBuffcmd = cmd;
#endif

#ifdef ARDUINO_PLATFORM
  Ft_Gpu_Hal_Wr32(phost,(RAM_DL+Ft_DlBuffer_Index),cmd);
#endif
  /* Increment the command index */
  Ft_DlBuffer_Index += FT_CMD_SIZE;  
}

ft_void_t Ft_App_WrCoStr_Buffer(Ft_Gpu_Hal_Context_t *phost,const ft_char8_t *s)
{
#ifdef  BUFFER_OPTIMIZATION  
  ft_uint16_t length = 0;
  length = strlen(s) + 1;//last for the null termination

  strcpy(&Ft_CmdBuffer[Ft_CmdBuffer_Index],s);  

  /* increment the length and align it by 4 bytes */
  Ft_CmdBuffer_Index += ((length + 3) & ~3);  
#endif  
}

ft_void_t Ft_App_Flush_DL_Buffer(Ft_Gpu_Hal_Context_t *phost)
{
#ifdef  BUFFER_OPTIMIZATION    
  if (Ft_DlBuffer_Index > 0)
    Ft_Gpu_Hal_WrMem(phost,RAM_DL,Ft_DlBuffer,Ft_DlBuffer_Index);
#endif     
  Ft_DlBuffer_Index = 0;

}


ft_void_t Ft_App_Flush_Co_Buffer(Ft_Gpu_Hal_Context_t *phost)
{
#ifdef  BUFFER_OPTIMIZATION    
  if (Ft_CmdBuffer_Index > 0)
    Ft_Gpu_Hal_WrCmdBuf(phost,Ft_CmdBuffer,Ft_CmdBuffer_Index);
#endif     
  Ft_CmdBuffer_Index = 0;
}


/* API to give fadeout effect by changing the display PWM from 100 till 0 */
ft_void_t SAMAPP_fadeout()
{
  ft_int32_t i;

  for (i = 100; i >= 0; i -= 3) 
  {
    Ft_Gpu_Hal_Wr8(phost,REG_PWM_DUTY,i);

    Ft_Gpu_Hal_Sleep(2);//sleep for 2 ms
  }
}

/* API to perform display fadein effect by changing the display PWM from 0 till 100 and finally 128 */
ft_void_t SAMAPP_fadein()
{
  ft_int32_t i;

  for (i = 0; i <=100 ; i += 3) 
  {
    Ft_Gpu_Hal_Wr8(phost,REG_PWM_DUTY,i);
    Ft_Gpu_Hal_Sleep(2);//sleep for 2 ms
  }
  /* Finally make the PWM 100% */
  i = 128;
  Ft_Gpu_Hal_Wr8(phost,REG_PWM_DUTY,i);
}

/* Optimized implementation of sin and cos table - precision is 16  */



/* API to check the status of previous DLSWAP and perform DLSWAP of new DL */
/* Check for the status of previous DLSWAP and if still not done wait for few ms and check again */
ft_void_t Ft_Gpu_DLSwap(ft_uint8_t DL_Swap_Type)
{
  ft_uint8_t Swap_Type = DLSWAP_FRAME,Swap_Done = DLSWAP_FRAME;

  if(DL_Swap_Type == DLSWAP_LINE)
  {
    Swap_Type = DLSWAP_LINE;
  }

  /* Perform a new DL swap */
  Ft_Gpu_Hal_Wr8(phost,REG_DLSWAP,Swap_Type);

  /* Wait till the swap is done */
  while(Swap_Done)
  {
    Swap_Done = Ft_Gpu_Hal_Rd8(phost,REG_DLSWAP);

    if(DLSWAP_DONE != Swap_Done)
    {
      Ft_Gpu_Hal_Sleep(10);//wait for 10ms
    }
  }	
}



/*****************************************************************************/
/* Example code to display few points at various offsets with various colors */



/* Boot up for FT800 followed by graphics primitive sample cases */
/* Initial boot up DL - make the back ground green color */
const ft_uint8_t FT_DLCODE_BOOTUP[12] = 
{
  255,255,255,2,//GPU instruction CLEAR_COLOR_RGB
  7,0,0,38, //GPU instruction CLEAR
  0,0,0,0,  //GPU instruction DISPLAY
};
// deflated  icon
static ft_uint8_t home_star_icon[] = {0x78,0x9C,0xE5,0x94,0xBF,0x4E,0xC2,0x40,0x1C,0xC7,0x7F,0x2D,0x04,0x8B,0x20,0x45,0x76,0x14,0x67,0xA3,0xF1,0x0D,0x64,0x75,0xD2,0xD5,0x09,0x27,0x17,0x13,0xE1,0x0D,0xE4,0x0D,0x78,0x04,0x98,0x5D,0x30,0x26,0x0E,0x4A,0xA2,0x3E,0x82,0x0E,0x8E,0x82,0xC1,0x38,0x62,0x51,0x0C,0x0A,0x42,0x7F,0xDE,0xB5,0x77,0xB4,0x77,0x17,0x28,0x21,0x26,0x46,0xFD,0x26,0xCD,0xE5,0xD3,0x7C,0xFB,0xBB,0xFB,0xFD,0xB9,0x02,0xCC,0xA4,0xE8,0x99,0x80,0x61,0xC4,0x8A,0x9F,0xCB,0x6F,0x31,0x3B,0xE3,0x61,0x7A,0x98,0x84,0x7C,0x37,0xF6,0xFC,0xC8,0xDD,0x45,0x00,0xDD,0xBA,0xC4,0x77,0xE6,0xEE,0x40,0xEC,0x0E,0xE6,0x91,0xF1,0xD2,0x00,0x42,0x34,0x5E,0xCE,0xE5,0x08,0x16,0xA0,0x84,0x68,0x67,0xB4,0x86,0xC3,0xD5,0x26,0x2C,0x20,0x51,0x17,0xA2,0xB8,0x03,0xB0,0xFE,0x49,0xDD,0x54,0x15,0xD8,0xEE,0x73,0x37,0x95,0x9D,0xD4,0x1A,0xB7,0xA5,0x26,0xC4,0x91,0xA9,0x0B,0x06,0xEE,0x72,0xB7,0xFB,0xC5,0x16,0x80,0xE9,0xF1,0x07,0x8D,0x3F,0x15,0x5F,0x1C,0x0B,0xFC,0x0A,0x90,0xF0,0xF3,0x09,0xA9,0x90,0xC4,0xC6,0x37,0xB0,0x93,0xBF,0xE1,0x71,0xDB,0xA9,0xD7,0x41,0xAD,0x46,0xEA,0x19,0xA9,0xD5,0xCE,0x93,0xB3,0x35,0x73,0x0A,0x69,0x59,0x91,0xC3,0x0F,0x22,0x1B,0x1D,0x91,0x13,0x3D,0x91,0x73,0x43,0xF1,0x6C,0x55,0xDA,0x3A,0x4F,0xBA,0x25,0xCE,0x4F,0x04,0xF1,0xC5,0xCF,0x71,0xDA,0x3C,0xD7,0xB9,0xB2,0x48,0xB4,0x89,0x38,0x20,0x4B,0x2A,0x95,0x0C,0xD5,0xEF,0x5B,0xAD,0x96,0x45,0x8A,0x41,0x96,0x7A,0x1F,0x60,0x0D,0x7D,0x22,0x75,0x82,0x2B,0x0F,0xFB,0xCE,0x51,0x3D,0x2E,0x3A,0x21,0xF3,0x1C,0xD9,0x38,0x86,0x2C,0xC6,0x05,0xB6,0x7B,0x9A,0x8F,0x0F,0x97,0x1B,0x72,0x6F,0x1C,0xEB,0xAE,0xFF,0xDA,0x97,0x0D,0xBA,0x43,0x32,0xCA,0x66,0x34,0x3D,0x54,0xCB,0x24,0x9B,0x43,0xF2,0x70,0x3E,0x42,0xBB,0xA0,0x95,0x11,0x37,0x46,0xE1,0x4F,0x49,0xC5,0x1B,0xFC,0x3C,0x3A,0x3E,0xD1,0x65,0x0E,0x6F,0x58,0xF8,0x9E,0x5B,0xDB,0x55,0xB6,0x41,0x34,0xCB,0xBE,0xDB,0x87,0x5F,0xA9,0xD1,0x85,0x6B,0xB3,0x17,0x9C,0x61,0x0C,0x9B,0xA2,0x5D,0x61,0x10,0xED,0x2A,0x9B,0xA2,0x5D,0x61,0x10,0xED,0x2A,0x9B,0xA2,0x5D,0x61,0x10,0xED,0x2A,0x9B,0xED,0xC9,0xFC,0xDF,0x14,0x54,0x8F,0x80,0x7A,0x06,0xF5,0x23,0xA0,0x9F,0x41,0xF3,0x10,0x30,0x4F,0x41,0xF3,0x18,0x30,0xCF,0xCA,0xFC,0xFF,0x35,0xC9,0x79,0xC9,0x89,0xFA,0x33,0xD7,0x1D,0xF6,0x5E,0x84,0x5C,0x56,0x6E,0xA7,0xDA,0x1E,0xF9,0xFA,0xAB,0xF5,0x97,0xFF,0x2F,0xED,0x89,0x7E,0x29,0x9E,0xB4,0x9F,0x74,0x1E,0x69,0xDA,0xA4,0x9F,0x81,0x94,0xEF,0x4F,0xF6,0xF9,0x0B,0xF4,0x65,0x51,0x08};


PROGMEM char *info[] = { 
                         "FT800 MainMenu Application",
                         "APP to demonstrate interactive menus,",
                         "using Jpeg decode,",
                         "Rectangle & Points."

                       }; 

                             
                             
static ft_int32_t fsize = 0;
static ft_uint8_t sd_present =0;


Reader imfile;

// API used to play the KEYsound
void Ft_Play_Sound(ft_uint8_t sound,ft_uint8_t vol,ft_uint8_t midi)
{
  ft_uint16_t val = (midi << 8) | sound; 
  Ft_Gpu_Hal_Wr8(phost,REG_SOUND,val);
  Ft_Gpu_Hal_Wr8(phost,REG_PLAY,1); 
}

static struct {
  signed short dragprev;
  int vel;      // velocity
  long base;    // screen x coordinate, in 1/16ths pixel
  long limit;
} scroller;

/* Api to Intialise the scroller*/
static void scroller_init(ft_uint32_t limit)
{
  scroller.dragprev = -32768;
  scroller.vel = 0;      // velocity
  scroller.base = 0;     // screen x coordinate, in 1/16ths pixel
  scroller.limit = limit;
}
/* Api used to scroll the screen horizontally*/
static void scroller_run()
{
  signed short sx = Ft_Gpu_Hal_Rd16(phost,REG_TOUCH_SCREEN_XY + 2);
  if ((sx != -32768) & (scroller.dragprev != -32768)) {
    scroller.vel = (scroller.dragprev - sx) << 4;
  } else {
    int change = max(1, abs(scroller.vel) >> 5);
    if (scroller.vel < 0)
      scroller.vel += change;
    if (scroller.vel > 0)
      scroller.vel -= change;
  }
  scroller.dragprev = sx;
  scroller.base += scroller.vel;
  scroller.base = max(0, min(scroller.base, scroller.limit));
}
/********API to return the assigned TAG value when penup,for the primitives/widgets******/
ft_uint8_t Read_keys()
{
  static ft_uint8_t 
          	    tag,
		    temp_tag=0,
		    menu_no=0;

  tag = Ft_Gpu_Hal_Rd8(phost,REG_TOUCH_TAG);
  if(tag!=NULL && tag!=temp_tag)
  temp_tag = tag;
 
  if(tag==NULL)
  {
    if(temp_tag!=NULL)
    {	
       menu_no = temp_tag;
       Ft_Play_Sound(0x51,100,108);	
    }
    else
    {
	menu_no = 0;
    }
    temp_tag = 0;
  }
  return menu_no;
}

static ft_uint8_t sk=0;
ft_uint8_t Read_Keys()
{
  static ft_uint8_t Read_tag=0,temp_tag=0,ret_tag=0;	
  Read_tag = Ft_Gpu_Hal_Rd8(phost,REG_TOUCH_TAG);
  ret_tag = NULL;
  if(Read_tag!=NULL)								// Allow if the Key is released
  {
    if(temp_tag!=Read_tag)
    {
      temp_tag = Read_tag;	
      sk = Read_tag;										// Load the Read tag to temp variable	
    }  
  }
  else
  {
    if(temp_tag!=0)
    {
      ret_tag = temp_tag;
    }  
    sk = 0;
  }
  return ret_tag;
}

/* Load the icons of the menu to GRAM*/ 
void Load_Thumbnails()
{
  char *apps[] = {"1.jpg","2.jpg","3.jpg","4.jpg","5.jpg","6.jpg","7.jpg","8.jpg","9.jpg","10.jpg","11.jpg","12.jpg"};
  ft_uint8_t 				
        	imn,fnf=0;

  ft_int16_t		
		fsize=0,
		blklen = 10*1024L,
		wsize;

  ft_uint8_t temp[512];
  imn = 0;
  if(sd_present==0)
  {
    for(imn=0;imn<12;imn++)
    {
       Ft_Gpu_CoCmd_Dlstart(phost); 
      Ft_Gpu_CoCmd_MemSet(phost,THUMBNAIL_ADDRESS+(imn*blklen),ft_random(150),50*2*100);
        Ft_Gpu_CoCmd_Swap(phost);
      Ft_App_Flush_Co_Buffer(phost);
      Ft_Gpu_Hal_WaitCmdfifo_empty(phost);
//      delay(100);
    }  
    return;
  }
  do
  {
    byte ifile = imfile.openfile(apps[imn]);
    fsize  = imfile.size;
    if(fsize==NULL)
    {
      Ft_Gpu_Hal_WrCmd32(phost,CMD_MEMSET);
      Ft_Gpu_Hal_WrCmd32(phost,imn*blklen);
      Ft_Gpu_Hal_WrCmd32(phost,ft_random(150));
      Ft_Gpu_Hal_WrCmd32(phost,ft_random(10*1024L));
    }
    else
    {
	Ft_Gpu_Hal_WrCmd32(phost,CMD_LOADIMAGE);
	Ft_Gpu_Hal_WrCmd32(phost,THUMBNAIL_ADDRESS+(imn*blklen));
	Ft_Gpu_Hal_WrCmd32(phost,0);
    }
    while(fsize > 0)
    {
      wsize = fsize > 512L ? 512L:fsize;
      imfile.readsector(temp);
      fsize -= wsize;
      Ft_Gpu_Hal_WrCmdBuf(phost,temp,wsize);				// copy data continuously into command memory 
    }
    imn++;
  }while(imn<MAX_MENUS);
}




/***********************API used to SET the ICON******************************************/
/*Refer the code flow in the flowchart availble in the Application Note */


ft_void_t home_setup()
{
  /*Icon  file is deflated use J1 Command to inflate the file and write into the GRAM*/
  Ft_Gpu_Hal_WrCmd32(phost,CMD_INFLATE);
  Ft_Gpu_Hal_WrCmd32(phost,250*1024L);
  Ft_Gpu_Hal_WrCmdBuf(phost,home_star_icon,sizeof(home_star_icon));
  /*Set the Bitmap properties for the ICONS*/
  Ft_Gpu_CoCmd_Dlstart(phost);        // start
  Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));
  Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(255, 255, 255));
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(13));    // handle for background stars
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_SOURCE(250*1024L));      // Starting address in gram
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_LAYOUT(L4, 16, 32));  // format 
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_SIZE(NEAREST, REPEAT, REPEAT, 512, 512  ));
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(14));    // handle for background stars
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_SOURCE(250*1024L));      // Starting address in gram
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_LAYOUT(L4, 16, 32));  // format 
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_SIZE(NEAREST, BORDER, BORDER, 32, 32  ));
  Ft_App_WrCoCmd_Buffer(phost,DISPLAY());
  Ft_Gpu_CoCmd_Swap(phost);
  Ft_App_Flush_Co_Buffer(phost);
  Ft_Gpu_Hal_WaitCmdfifo_empty(phost);
}
//==============================================Information Screen =======================================
ft_void_t Info()
{
  ft_uint16_t dloffset = 0,z;
  Ft_CmdBuffer_Index = 0;
// Touch Screen Calibration
  Ft_Gpu_CoCmd_Dlstart(phost); 
  Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));
  Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(255,255,255));
  Ft_Gpu_CoCmd_Text(phost,FT_DispWidth/2,FT_DispHeight/2,26,OPT_CENTERX|OPT_CENTERY,"Please tap on a dot");
  Ft_Gpu_CoCmd_Calibrate(phost,0);
  Ft_App_WrCoCmd_Buffer(phost,DISPLAY());
  Ft_Gpu_CoCmd_Swap(phost);
  Ft_App_Flush_Co_Buffer(phost);
  Ft_Gpu_Hal_WaitCmdfifo_empty(phost);
// Ftdi Logo animation 
  Ft_Gpu_CoCmd_Logo(phost);
  Ft_App_Flush_Co_Buffer(phost);
  Ft_Gpu_Hal_WaitCmdfifo_empty(phost);
  while(0!=Ft_Gpu_Hal_Rd16(phost,REG_CMD_READ)); 
  dloffset = Ft_Gpu_Hal_Rd16(phost,REG_CMD_DL);
  dloffset -=4;
  //Copy the Displaylist from DL RAM to GRAM
  Ft_Gpu_Hal_WrCmd32(phost,CMD_MEMCPY);
  Ft_Gpu_Hal_WrCmd32(phost,100000L);
  Ft_Gpu_Hal_WrCmd32(phost,RAM_DL);
  Ft_Gpu_Hal_WrCmd32(phost,dloffset);
  do
  {
    Ft_Gpu_CoCmd_Dlstart(phost);   
    Ft_Gpu_CoCmd_Append(phost,100000L,dloffset);
    //Reset the BITMAP properties used during Logo animation
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_A(256));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_A(256));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_B(0));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_C(0));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_D(0));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_E(256));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_F(0));  
    Ft_App_WrCoCmd_Buffer(phost,SAVE_CONTEXT());	
    //Display the information with transparent Logo using Edge Strip 
    Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(219,180,150));
    Ft_App_WrCoCmd_Buffer(phost,COLOR_A(220));
    Ft_App_WrCoCmd_Buffer(phost,BEGIN(EDGE_STRIP_A));
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(0,FT_DispHeight*16));
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(FT_DispWidth*16,FT_DispHeight*16));
    Ft_App_WrCoCmd_Buffer(phost,COLOR_A(255));
    Ft_App_WrCoCmd_Buffer(phost,RESTORE_CONTEXT());	
    Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(0,0,0));
   // INFORMATION 
    Ft_Gpu_CoCmd_Text(phost,FT_DispWidth/2,20,28,OPT_CENTERX|OPT_CENTERY,(char*)pgm_read_word(&info[0]));
    Ft_Gpu_CoCmd_Text(phost,FT_DispWidth/2,60,26,OPT_CENTERX|OPT_CENTERY,(char*)pgm_read_word(&info[1]));
    Ft_Gpu_CoCmd_Text(phost,FT_DispWidth/2,90,26,OPT_CENTERX|OPT_CENTERY,(char*)pgm_read_word(&info[2]));  
    Ft_Gpu_CoCmd_Text(phost,FT_DispWidth/2,120,26,OPT_CENTERX|OPT_CENTERY,(char*)pgm_read_word(&info[3]));  
    Ft_Gpu_CoCmd_Text(phost,FT_DispWidth/2,FT_DispHeight-30,26,OPT_CENTERX|OPT_CENTERY,"Click to play");
    //Check if the Play key and change the color
    if(sk!='P')
    Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(255,255,255));
    else
    Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(100,100,100));
    Ft_App_WrCoCmd_Buffer(phost,BEGIN(FTPOINTS));   
    Ft_App_WrCoCmd_Buffer(phost,POINT_SIZE(20*16));
    Ft_App_WrCoCmd_Buffer(phost,TAG('P'));
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((FT_DispWidth/2)*16,(FT_DispHeight-60)*16));
    Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(180,35,35));
    Ft_App_WrCoCmd_Buffer(phost,BEGIN(BITMAPS));
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2II((FT_DispWidth/2)-14,(FT_DispHeight-75),14,4));
    Ft_App_WrCoCmd_Buffer(phost,DISPLAY());
    Ft_Gpu_CoCmd_Swap(phost);
    Ft_App_Flush_Co_Buffer(phost);
    Ft_Gpu_Hal_WaitCmdfifo_empty(phost);
  }while(Read_Keys()!='P');
  /* wait until Play key is not pressed*/
}

/* API for android method*/

void menu()
{
  ft_uint8_t 
  	imh = 50,
	imw = 100,
	dt = 30,dx,dy,
	col,row,per_f,n_f,c_f=0,
	i,key_in=0,dg_count=0,temp=0;

  ft_int16_t Ox,Oy,sx,drag=0,prev=0,drag_dt=30,dragth=0,dragpv=0,ddt;
  
  #define NOTOUCH		-32768
   
// for points

  ft_uint8_t  Opt,pdt =15;

 
  dx = (dt*2)+imw;	
  dy = (10*2)+imh;
  col = FT_DispWidth/dx;
  row = 2;
  per_f = col*row;
  n_f = (MAX_MENUS-1)/per_f;

  Opt = (FT_DispWidth-(n_f+1)*(MENU_POINTSIZE+pdt))/2;
  
  Load_Thumbnails();


  Ft_Gpu_Hal_WrCmd32(phost,CMD_INFLATE);
  Ft_Gpu_Hal_WrCmd32(phost,121*1024L);
  Ft_Gpu_Hal_WrCmdBuf(phost,home_star_icon,sizeof(home_star_icon));
  Ft_Gpu_CoCmd_Dlstart(phost);   	
  Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));	
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(12));
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_SOURCE(121*1024L));
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_LAYOUT(L4, 16, 32));
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_SIZE(NEAREST, BORDER, BORDER, 32, 32));
  for(temp=0;temp<MAX_MENUS;temp++)
  {
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(temp));	
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_SOURCE(THUMBNAIL_ADDRESS+(temp*10*1024L)));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_LAYOUT(RGB565,100*2,50));	
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_SIZE(BILINEAR, BORDER, BORDER, 100, 50));	
  }
  temp = 0;
  Ft_App_WrCoCmd_Buffer(phost,DISPLAY());
  Ft_Gpu_CoCmd_Swap(phost);
  Ft_App_Flush_Co_Buffer(phost);
  Ft_Gpu_Hal_WaitCmdfifo_empty(phost);	
  scroller_init((FT_DispWidth*n_f)*16);
//  Serial.begin(9600);
  while(1)
  {
/*Read touch screen x varaiation and tag in*/
    sx =  Ft_Gpu_Hal_Rd16(phost,REG_TOUCH_SCREEN_XY + 2);
    key_in =  Ft_Gpu_Hal_Rd8(phost,REG_TOUCH_TAG);
//    Serial.println(key_in,DEC);   		
/*Check if any tag in*/    
    if(sx!=NOTOUCH)	
    {
      dg_count++;     	
      temp = key_in;
    }
/*Move into the particular frame based on dragdt now 30pixels*/
    if(sx==NOTOUCH)
    {
      dg_count = 0; 		
      if(drag>((c_f*FT_DispWidth)+drag_dt)) drag = min((c_f+1)*FT_DispWidth,drag+15); 
      if(drag<((c_f*FT_DispWidth)-drag_dt)) drag = max((c_f-1)*FT_DispWidth,drag-15); 
      if(dragth==drag) c_f = drag/FT_DispWidth;
      dragth = drag;
      scroller.vel = 0; 
      scroller.base = dragth*16;				// 16bit pre
 //     temp = 0;
   }
/*if tag in but still pendown take a scroller basevalue*/
   else if(dg_count>5)
   {
      key_in = 0;
      temp = 0;
      drag = scroller.base>>4;
    }
    if(key_in==0)  scroller_run();
 /*Display list start*/   
    Ft_Gpu_CoCmd_Dlstart(phost);   
    Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1)); 
    Ft_App_WrCoCmd_Buffer(phost,SCISSOR_XY(0,0));
    Ft_App_WrCoCmd_Buffer(phost,SCISSOR_SIZE(FT_DispWidth,FT_DispHeight));
    Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));
    Ft_Gpu_CoCmd_Gradient(phost,0,0,0x1A99E8,0,FT_DispHeight,0x0A4F7A);
    Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(255,255,255));
    Ft_App_WrCoCmd_Buffer(phost,LINE_WIDTH(25));				// for rect	
    Ft_App_WrCoCmd_Buffer(phost,BEGIN(RECTS));
    Oy = 10;
    for(i=0;i<=n_f;i++)
    {
      Ox = 10;  
      Ox+=(i*FT_DispWidth);
      Ox-=drag;
      if(i==0) Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(156,100,128));
      if(i==1) Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(100,106,156));
      if(i==2) Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(156,152,100));   
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((Ox)*16,(Oy)*16));	
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((Ox+FT_DispWidth-20)*16,(ft_int16_t)(FT_DispHeight*0.75)*16));					// i pixels wide than image width +1 
    }
    Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(255,255,255)); 
     for(i=0;i<MAX_MENUS;i++)
    {
      Ox = dt+dx*(i%col);                                          // Calculate the xoffsets
      Ox +=((i/per_f)*FT_DispWidth);       
      Ox -= drag;        
      Oy = dt+(dy*((i/col)%row));
      if(Ox > (FT_DispWidth+dt)) 0;	
      else
      {
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((Ox-1)*16,(Oy-1)*16));	
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((imw+Ox+1)*16,(imh+Oy+1)*16));}					// i pixels wide than image width +1
    } 
    Ft_App_WrCoCmd_Buffer(phost,TAG_MASK(1)); 
    Ft_App_WrCoCmd_Buffer(phost,BEGIN(BITMAPS));		
    for(i=0;i<MAX_MENUS;i++)
    {
      Ox = dt+dx*(i%col);                                          // Calculate the xoffsets
      Ox +=((i/per_f)*FT_DispWidth);       
      Ox -= drag;        
      Oy = dt+(dy*((i/col)%row));	
      if(Ox > (FT_DispWidth+dt) || Ox < -dx) 0;	
      else
      {
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(i));
      Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(Ox*16,Oy*16));	
      }
    }
    Ft_App_WrCoCmd_Buffer(phost,TAG_MASK(0));
  
  // frame_no_points
  
    Ft_App_WrCoCmd_Buffer(phost,POINT_SIZE(MENU_POINTSIZE*16));
    Ft_App_WrCoCmd_Buffer(phost,BEGIN(FTPOINTS));				
    Ft_App_WrCoCmd_Buffer(phost,COLOR_A(50));	
    Oy = FT_DispHeight - 20;
    for(i=0;i<=n_f;i++)
    {
      Ox = Opt+(i*(MENU_POINTSIZE+pdt));
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(Ox*16,Oy*16));		
    }
    
    Ox = Opt+(c_f*(MENU_POINTSIZE+pdt));
    Ft_App_WrCoCmd_Buffer(phost,COLOR_A(255));
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(Ox*16,Oy*16));	
    
    Ft_App_WrCoCmd_Buffer(phost,DISPLAY());
    Ft_Gpu_CoCmd_Swap(phost);
    Ft_App_Flush_Co_Buffer(phost);
    Ft_Gpu_Hal_WaitCmdfifo_empty(phost);	
    key_in = temp; 

//   Show the  entered menu
    if(key_in!=0 && key_in<=12 && sx==NOTOUCH)
    {	
      Ft_Gpu_CoCmd_Dlstart(phost);   
      Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));
      Ft_App_WrCoCmd_Buffer(phost,SCISSOR_XY(0,0));
      Ft_App_WrCoCmd_Buffer(phost,SCISSOR_SIZE(FT_DispWidth,FT_DispHeight));
      Ft_App_WrCoCmd_Buffer(phost,CLEAR_COLOR_RGB(0x1A,0xE8,55));
      Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));
      Ft_Gpu_CoCmd_Gradient(phost,0,0,0x1A99E8,0,FT_DispHeight,0x0A4F7A);
      Ft_App_WrCoCmd_Buffer(phost,BEGIN(BITMAPS));
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(key_in-1));
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_A(128));
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_E(128));
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_SIZE(NEAREST,BORDER,BORDER,200,100)); 
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(((FT_DispWidth-200)/2)*16,((FT_DispHeight-100)/2)*16));	
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_A(256));
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_E(256));
      Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(255,255,255));
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(14));
      Ft_App_WrCoCmd_Buffer(phost,TAG('H'));
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(5*16,5*16));	
      Ft_App_WrCoCmd_Buffer(phost,DISPLAY());
      Ft_Gpu_CoCmd_Swap(phost);
      Ft_App_Flush_Co_Buffer(phost);
      Ft_Gpu_Hal_WaitCmdfifo_empty(phost);	
      while(Read_keys()!='H');	
      //* wait until the home is pressed*//
      key_in = 0;temp = key_in;
    }
  }
}

// Api to Single Row//
void menu_loopback()
{
	
  ft_uint8_t 
		imh = 50,
		imw = 100,
        	dt = 30,dx,dy,
		col,row,per_f,n_f,c_f=0,
		key_in=0,dg_count=0,temp=0;

  ft_int16_t Ox,Oy,sx,drag=0,prev=0,drag_dt=30,dragth=0,dragpv=0,temp_drag=0,i,cts=0;

  ft_uint8_t  Opt,pdt=15;
  
  
  dx = (dt*2)+imw;	
  dy = (10*2)+imh;
  col = FT_DispWidth/dx;
  row = 1;
  per_f = col*row;
  n_f = (MAX_MENUS-1)/per_f;

  Opt = (FT_DispWidth-(n_f+1)*(MENU_POINTSIZE+pdt))/2;
  Load_Thumbnails();
  Ft_Gpu_Hal_WrCmd32(phost,CMD_INFLATE);
  Ft_Gpu_Hal_WrCmd32(phost,121*1024L);
  Ft_Gpu_Hal_WrCmdBuf(phost,home_star_icon,sizeof(home_star_icon));
  Ft_CmdBuffer_Index =0;
  Ft_Gpu_CoCmd_Dlstart(phost);   	
  Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));	
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(12));
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_SOURCE(121*1024L));
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_LAYOUT(L4, 16, 32));
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_SIZE(NEAREST, BORDER, BORDER, 32, 32));
  for(temp=0;temp<MAX_MENUS;temp++)
  {
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(temp));	
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_SOURCE(THUMBNAIL_ADDRESS+(temp*10*1024L)));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_LAYOUT(RGB565,100*2,50));	
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_SIZE(BILINEAR, BORDER, BORDER, 100, 50));	
  }
  temp = 0;
  Ft_App_WrCoCmd_Buffer(phost,DISPLAY());
  Ft_Gpu_CoCmd_Swap(phost);
  Ft_App_Flush_Co_Buffer(phost);
  Ft_Gpu_Hal_WaitCmdfifo_empty(phost);	
  scroller_init((FT_DispWidth*n_f)*16);

  while(1)
  {
/*Read touch screen x varaiation and tag in*/
    sx =  Ft_Gpu_Hal_Rd16(phost,REG_TOUCH_SCREEN_XY + 2);
    key_in =  Ft_Gpu_Hal_Rd8(phost,REG_TOUCH_TAG);	
 
/*Check if any tag in*/    
    if(sx!=NOTOUCH)	
    {
      dg_count++;     	
      temp = key_in;
      
    }
/*Move into the particular frame based on dragdt now 30pixels*/
   if(sx==NOTOUCH)
   {
      dg_count = 0;
      drag = scroller.base>>4; 	
   }
/*if tag in but still pendown take a scroller basevalue*/
   else if(dg_count>5)
   {
      key_in = 0;
      temp = key_in;
      drag = scroller.base>>4;
   }
   if(key_in==0)scroller_run();
		
   Ft_CmdBuffer_Index =0;
   Ft_Gpu_CoCmd_Dlstart(phost);   
   Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));
   Ft_App_WrCoCmd_Buffer(phost,SCISSOR_XY(0,0));
   Ft_App_WrCoCmd_Buffer(phost,SCISSOR_SIZE(FT_DispWidth,FT_DispHeight));
   Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));
   Ft_Gpu_CoCmd_Gradient(phost,0,0,0x1A99E8,0,FT_DispHeight,0x0A4F7A);
   Ft_App_WrCoCmd_Buffer(phost,TAG_MASK(1));
   Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(255,255,255));
   Ft_App_WrCoCmd_Buffer(phost,LINE_WIDTH(1*16));				// for rect	
   Oy = (FT_DispHeight-imw)/2;					//dt+(dy*((i/col)%row));
   cts = drag/dx;                       // noof items moved in +/- directions
   dragth = drag%dx;
   for(i=-1;i<(per_f+1);i++)
   {
    Ox = dt+dx*i;
    Ox-=dragth;
    if(Ox > (FT_DispWidth+dt) || Ox < -dx) 0;						
    else
    {
      Ft_App_WrCoCmd_Buffer(phost,BEGIN(RECTS));
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((Ox-1)*16,(Oy-1)*16));	
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((imw+Ox+1)*16,(imh+Oy+1)*16));					// i pixels wide than image width +1
      Ft_App_WrCoCmd_Buffer(phost,BEGIN(BITMAPS));											// draw the bitmap
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE((MAX_MENUS+i+cts)%12));
      Ft_App_WrCoCmd_Buffer(phost,TAG((1+i+cts)%(MAX_MENUS+1)));	
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(Ox*16,Oy*16));	
    }
   }
   Ft_App_WrCoCmd_Buffer(phost,DISPLAY());
   Ft_Gpu_CoCmd_Swap(phost);
   Ft_App_Flush_Co_Buffer(phost);
   Ft_Gpu_Hal_WaitCmdfifo_empty(phost);	
   
   key_in = temp;
   //   Show the  entered menu
   if(key_in!=0 && key_in<=12 && sx==NOTOUCH)
   {	
	
      Ft_Gpu_CoCmd_Dlstart(phost);   
      Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));
      Ft_App_WrCoCmd_Buffer(phost,SCISSOR_XY(0,0));
      Ft_App_WrCoCmd_Buffer(phost,SCISSOR_SIZE(FT_DispWidth,FT_DispHeight));
      Ft_App_WrCoCmd_Buffer(phost,CLEAR_COLOR_RGB(0x1A,0xE8,55));
      Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));
      Ft_Gpu_CoCmd_Gradient(phost,0,0,0x1A99E8,0,FT_DispHeight,0x0A4F7A);
      Ft_App_WrCoCmd_Buffer(phost,BEGIN(BITMAPS));
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(key_in-1));
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_A(128));
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_E(128));
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_SIZE(NEAREST,BORDER,BORDER,200,100)); 
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(((FT_DispWidth-200)/2)*16,((FT_DispHeight-100)/2)*16));	
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_A(256));
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_E(256));
      Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(255,255,255));
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(14));
      Ft_App_WrCoCmd_Buffer(phost,TAG('H'));
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(5*16,5*16));	
      Ft_App_WrCoCmd_Buffer(phost,DISPLAY());
      Ft_Gpu_CoCmd_Swap(phost);
      Ft_App_Flush_Co_Buffer(phost);
      Ft_Gpu_Hal_WaitCmdfifo_empty(phost);	
      while(Read_keys()!='H');	
            //* wait until the home is pressed*//
      key_in = 0;temp = key_in;
    }
  }  
}  

// Api to tiles type menu*/
void menu_win8()
{
  ft_uint8_t 
	imh = 50,imw = 100,dt = 30,dx,dy,col,row,per_f,n_f,c_f=0,
        i,key_in=0,dg_count=0,temp=0;
	ft_int16_t Ox,Oy,sx,drag=0,prev=0,dragth=0,dragpv=0,ddt;

	ft_uint8_t color[12][3] = {  0xE0,0x01B,0xA2,
				     0x1B,0xE0,0xA8,
				     0x9E,0x9E,0x73,
				     0xE0,0x8E,0x1B,
				     0xB8,0x91,0xB3,
		                     0x6E,0x96,0x8e,
				     0x1B,0x60,0xE0,
				     0xC7,0xE3,0x7B,
				     0x8B,0x1B,0xE0,
				     0xE3,0x91,0xC1,
				     0xE0,0x8E,0x1B,
				     0xAC,0x91,0xE3,
				};

	char *mes[20]=	{  "Music",  "Gauges ",  "Gradient",  "Photo",  "Metaball",  "Notepad",  "Signature",  "Sketch","Swiss","Waves","Player","Clocks"};

// for points

	ft_uint8_t  Opt,ps = 5,pdt=15;

	
  dx = (dt*2)+imw;	
  dy = (10*2)+imh;
  col = FT_DispWidth/dx;
  row = 2;
  per_f = col*row;
  n_f = (MAX_MENUS-1)/per_f;
  Opt = (FT_DispWidth-(n_f+1)*(ps+pdt))/2;
  
  Load_Thumbnails();
  Ft_Gpu_Hal_WrCmd32(phost,CMD_INFLATE);
  Ft_Gpu_Hal_WrCmd32(phost,121*1024L);
  Ft_Gpu_Hal_WrCmdBuf(phost,home_star_icon,sizeof(home_star_icon));
  Ft_CmdBuffer_Index =0;
  Ft_Gpu_CoCmd_Dlstart(phost);   	
  Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));	
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(12));
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_SOURCE(121*1024L));
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_LAYOUT(L4, 16, 32));
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_SIZE(NEAREST, BORDER, BORDER, 32, 32));
  for(temp=0;temp<MAX_MENUS;temp++)
  {
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(temp));	
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_SOURCE(THUMBNAIL_ADDRESS+(temp*10*1024L)));
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_LAYOUT(RGB565,100*2,50));	
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_SIZE(BILINEAR, BORDER, BORDER, 100, 50));	
  }
  temp = 0;
  Ft_App_WrCoCmd_Buffer(phost,DISPLAY());
  Ft_Gpu_CoCmd_Swap(phost);
  Ft_App_Flush_Co_Buffer(phost);
  Ft_Gpu_Hal_WaitCmdfifo_empty(phost);	
  scroller_init((FT_DispWidth*n_f)*16);
  while(1)
  {
    sx =  Ft_Gpu_Hal_Rd16(phost,REG_TOUCH_SCREEN_XY + 2);
    key_in =  Ft_Gpu_Hal_Rd8(phost,REG_TOUCH_TAG);
    if(key_in!=0)
    key_in = key_in;
    if(sx!=NOTOUCH)	
    {
      dg_count++;	
      temp = key_in;
    }
    if(sx==NOTOUCH)
    {
      dg_count = 0;	
      drag = scroller.base>>4; 		
    }
    else if(dg_count>5)
    {
      key_in = 0;
      temp = key_in;
      drag = scroller.base>>4;
    }
    if(key_in==0)
    {
      scroller_run();
    }
   Ft_CmdBuffer_Index =0;
   Ft_Gpu_CoCmd_Dlstart(phost);   
   Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));
   Ft_App_WrCoCmd_Buffer(phost,SCISSOR_XY(0,0));
   Ft_App_WrCoCmd_Buffer(phost,SCISSOR_SIZE(FT_DispWidth,FT_DispHeight));
   Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));
   Ft_Gpu_CoCmd_Gradient(phost,0,0,0x1A99E8,0,FT_DispHeight,0x0A4F7A);
   Ft_App_WrCoCmd_Buffer(phost,TAG_MASK(1));
   Ft_App_WrCoCmd_Buffer(phost,CLEAR_TAG(0));
   Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(255,255,255));
   Ft_App_WrCoCmd_Buffer(phost,LINE_WIDTH(1*16));				// for rect	
   Ft_App_WrCoCmd_Buffer(phost,BEGIN(RECTS));

#ifdef SAMAPP_DISPLAY_WQVGA

   imw = 220;
   imh = 100;		
   for(i=0;i<12;i+=6)
   {
    Ox = 10+FT_DispWidth*(i/6);
    Ox -= drag;
    Oy = 10+(110*((i/col)%row));
    Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(color[i][0],color[i][1],color[i][2]));
    Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((Ox)*16,(Oy)*16));	
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((imw+Ox+1)*16,(100+Oy+1)*16));					// i pixels wide than image width +1
   }
   for(i=5;i<12;i+=6)
   {
     Ox = 250+FT_DispWidth*(i/6);
     Ox -= drag;
     Oy = 10+(110*((i/col)%row));
     Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(color[i][0],color[i][1],color[i][2]));
     Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
     Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((Ox)*16,(Oy)*16));	
     Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((imw+Ox+1)*16,(100+Oy+1)*16));					// i pixels wide than image width +1
   }

   imw = 100;
   imh = 100;	

   for(i=1;i<3;i+=1)
   {
     Ox = 250+FT_DispWidth*(i/per_f)+120*(i/2);
     Ox -= drag;
     Oy = 10+(110*((i/col)%row));
     Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(color[i][0],color[i][1],color[i][2]));
     Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
     Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((Ox)*16,(Oy)*16));	
     Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((imw+Ox+1)*16,(100+Oy+1)*16));					// i pixels wide than image width +1
   }
   for(i=3;i<5;i+=1)
   {
     Ox = 10+FT_DispWidth*(i/per_f)+120*(i/4);
     Ox -= drag;
     Oy = 10+(110*((i/col)%row));
     Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(color[i][0],color[i][1],color[i][2]));
     Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
     Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((Ox)*16,(Oy)*16));	
     Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((imw+Ox+1)*16,(100+Oy+1)*16));					// i pixels wide than image width +1
   }
   for(i=7;i<9;i+=1)
   {
     Ox = 250+FT_DispWidth*(i/per_f)+120*(i/8);
     Ox -= drag;
     Oy = 10+(110*((i/col)%row));
     Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(color[i][0],color[i][1],color[i][2]));
     Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
     Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((Ox)*16,(Oy)*16));	
     Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((imw+Ox+1)*16,(100+Oy+1)*16));					// i pixels wide than image width +1
   }
   for(i=9;i<11;i+=1)
   {
     Ox = 10+FT_DispWidth*(i/per_f)+120*(i/10);
     Ox -= drag;
     Oy = 10+(110*((i/col)%row));
     Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(color[i][0],color[i][1],color[i][2]));
     Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
     Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((Ox)*16,(Oy)*16));	
     Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((imw+Ox+1)*16,(100+Oy+1)*16));					// i pixels wide than image width +1
    }
    
    
    Ft_App_WrCoCmd_Buffer(phost,TAG_MASK(0));
    
    Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(255,255,255));
    for(i=0;i<12;i+=6)
    {
      Ox = 10+FT_DispWidth*(i/4);
      Ox -= drag;
      Oy = 10+(110*((i/col)%row));
      Ft_Gpu_CoCmd_Text(phost,Ox+10,Oy+80,26,0,mes[i]);
    }
    for(i=5;i<12;i+=6)
    {
      Ox = 250+FT_DispWidth*(i/6);
      Ox -= drag;
      Oy = 10+(110*((i/col)%row));
      Ft_Gpu_CoCmd_Text(phost,Ox+10,Oy+80,26,0,mes[i]);
    }
    for(i=1;i<3;i+=1)
    {
      Ox = 250+FT_DispWidth*(i/per_f)+120*(i/2);
      Ox -= drag;
      Oy = 10+(110*((i/col)%row));
      Ft_Gpu_CoCmd_Text(phost,Ox+10,Oy+80,26,0,mes[i]);
    }
    for(i=3;i<5;i+=1)
    {
      Ox = 10+FT_DispWidth*(i/per_f)+120*(i/4);
      Ox -= drag;
      Oy = 10+(110*((i/col)%row));
      Ft_Gpu_CoCmd_Text(phost,Ox+10,Oy+80,26,0,mes[i]);
    }

    for(i=7;i<9;i+=1)
    {
      Ox = 250+FT_DispWidth*(i/per_f)+120*(i/8);
      Ox -= drag;
      Oy = 10+(110*((i/col)%row));
      Ft_Gpu_CoCmd_Text(phost,Ox+10,Oy+80,26,0,mes[i]);
    }
    for(i=9;i<11;i+=1)
    {
      Ox = 10+FT_DispWidth*(i/per_f)+120*(i/10);
      Ox -= drag;
      Oy = 10+(110*((i/col)%row));
      Ft_Gpu_CoCmd_Text(phost,Ox+10,Oy+80,26,0,mes[i]);
    }
// Draw the bitmaps

   Ft_App_WrCoCmd_Buffer(phost,BEGIN(BITMAPS));
   for(i=0;i<12;i+=6)
   {
      Ox = 65+FT_DispWidth*(i/6);
      Ox -= drag;
      Oy = 35+(110*((i/col)%row));
      Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(i));
      Ft_App_WrCoCmd_Buffer(phost,CLEAR_TAG(255));
//      Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
      Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(Ox*16,Oy*16));
  }
  for(i=5;i<12;i+=6)
  {
    Ox = 305+FT_DispWidth*(i/6);
    Ox -= drag;
    Oy = 35+(110*((i/col)%row));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(i));
    Ft_App_WrCoCmd_Buffer(phost,CLEAR_TAG(255));
 //   Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(Ox*16,Oy*16));
  }
		
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_A(512));

  for(i=1;i<3;i+=1)
  {
    Ox = 275+FT_DispWidth*(i/per_f)+120*(i/2);
    Ox -= drag;
    Oy = 35+(110*((i/col)%row));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(i));
    Ft_App_WrCoCmd_Buffer(phost,CLEAR_TAG(255));
  //  Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(Ox*16,Oy*16));				// i pixels wide than image width +1
  }
  for(i=3;i<5;i+=1)
  {
    Ox = 35+FT_DispWidth*(i/per_f)+120*(i/4);
    Ox -= drag;
    Oy = 35+(110*((i/col)%row));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(i));
    Ft_App_WrCoCmd_Buffer(phost,CLEAR_TAG(255));
  //  Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(Ox*16,Oy*16));				// i pixels wide than image width +1
  }

  for(i=7;i<9;i+=1)
  {
    Ox = 275+FT_DispWidth*(i/per_f)+120*(i/8);
    Ox -= drag;
    Oy = 35+(110*((i/col)%row));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(i));
    Ft_App_WrCoCmd_Buffer(phost,CLEAR_TAG(255));
  //  Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(Ox*16,Oy*16));				// i pixels wide than image width +1
  }
  for(i=9;i<11;i+=1)
  {
    Ox = 35+FT_DispWidth*(i/per_f)+120*(i/10);
    Ox -= drag;
    Oy = 35+(110*((i/col)%row));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(i));
    Ft_App_WrCoCmd_Buffer(phost,CLEAR_TAG(255));
  //  Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(Ox*16,Oy*16));				// i pixels wide than image width +1
  }
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_A(256));
  
#else
//   Ft_App_WrCoCmd_Buffer(phost,TAG_MASK(1)); 		
  imw = 170;
  imh = 100;		
  for(i=0;i<12;i+=2)
  {
    Ox = 10+FT_DispWidth*(i/4);
    Ox -= drag;
    Oy = 10+(110*((i/col)%row));
    Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(color[i][0],color[i][1],color[i][2]));
     Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((Ox)*16,(Oy)*16));	
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((imw+Ox+1)*16,(100+Oy+1)*16));					// i pixels wide than image width +1
  }

  imw = 110;
  imh = 100;	

  for(i=1;i<12;i+=2)
  {
    Ox = 200+FT_DispWidth*(i/4);
    Ox -= drag;
    Oy = 10+(110*((i/col)%row));
    Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(color[i][0],color[i][1],color[i][2]));
        Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((Ox)*16,(Oy)*16));	
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F((imw+Ox+1)*16,(100+Oy+1)*16));					// i pixels wide than image width +1
  }
      Ft_App_WrCoCmd_Buffer(phost,TAG_MASK(0)); 
      
  Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(255,255,255));
  for(i=0;i<12;i+=2)
  {
    Ox = 10+FT_DispWidth*(i/4);
    Ox -= drag;
    Oy = 10+(110*((i/col)%row));
    Ft_Gpu_CoCmd_Text(phost,Ox+10,Oy+80,26,0,mes[i]);
  }
  for(i=1;i<12;i+=2)
  {
    Ox = 200+FT_DispWidth*(i/4);
    Ox -= drag;
    Oy = 10+(110*((i/col)%row));
    Ft_Gpu_CoCmd_Text(phost,Ox+10,Oy+80,26,0,mes[i]);
  }
		
  imw = 100;
  imh = 50;
  Ft_App_WrCoCmd_Buffer(phost,BEGIN(BITMAPS));											// draw the bitmap
  for(i=0;i<12;i+=2)
  {
    Ox = 75+FT_DispWidth*(i/4);
    Ox -= drag;
    Oy = 20+(110*((i/col)%row));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(i));
    Ft_App_WrCoCmd_Buffer(phost,CLEAR_TAG(255));
//    Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(Ox*16,Oy*16));	
  }
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_A(512));
  for(i=1;i<12;i+=2)
  {
    Ox = 230+FT_DispWidth*(i/4);
    Ox -= drag;
    Oy = 20+(110*((i/col)%row));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(i));
    Ft_App_WrCoCmd_Buffer(phost,CLEAR_TAG(255));
//    Ft_App_WrCoCmd_Buffer(phost,TAG(i+1));	
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(Ox*16,Oy*16));	
  }
  Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_A(256));
#endif
//  Ft_App_WrCoCmd_Buffer(phost,TAG_MASK(0));

  Ft_App_WrCoCmd_Buffer(phost,DISPLAY());
  Ft_Gpu_CoCmd_Swap(phost);
  Ft_App_Flush_Co_Buffer(phost);
  Ft_Gpu_Hal_WaitCmdfifo_empty(phost);	
  key_in = temp;
  // show the entered menu
  if(key_in!=0 && key_in<=12 && sx==NOTOUCH)
  {	
    Ft_CmdBuffer_Index =0;
    Ft_Gpu_CoCmd_Dlstart(phost);
    Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));
    Ft_App_WrCoCmd_Buffer(phost,SCISSOR_XY(0,0));
    Ft_App_WrCoCmd_Buffer(phost,SCISSOR_SIZE(FT_DispWidth,FT_DispHeight));
    Ft_App_WrCoCmd_Buffer(phost,CLEAR_COLOR_RGB(0x1A,0xE8,55));
    Ft_App_WrCoCmd_Buffer(phost,CLEAR(1,1,1));
    Ft_Gpu_CoCmd_Gradient(phost,0,0,0x1A99E8,0,FT_DispHeight,0x0A4F7A);
    Ft_App_WrCoCmd_Buffer(phost,BEGIN(BITMAPS));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(key_in-1));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_A(128));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_E(128));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_SIZE(NEAREST,BORDER,BORDER,200,100));
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(((FT_DispWidth-200)/2)*16,((FT_DispHeight-100)/2)*16));	
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_A(256));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_TRANSFORM_E(256));
    Ft_App_WrCoCmd_Buffer(phost,COLOR_RGB(255,255,255));
    Ft_App_WrCoCmd_Buffer(phost,BITMAP_HANDLE(14));
    Ft_App_WrCoCmd_Buffer(phost,TAG('H'));
    Ft_App_WrCoCmd_Buffer(phost,VERTEX2F(5*16,5*16));	
    Ft_App_WrCoCmd_Buffer(phost,DISPLAY());
    Ft_Gpu_CoCmd_Swap(phost);
    Ft_App_Flush_Co_Buffer(phost);
    Ft_Gpu_Hal_WaitCmdfifo_empty(phost);				
    while(Read_keys()!='H');	
   //* wait until the home is pressed*//
    key_in = 0;  temp = key_in;
   }
  }
}

#ifdef MSVC_PLATFORM
/* Main entry point */
ft_int32_t main(ft_int32_t argc,ft_char8_t *argv[])
#endif
#ifdef ARDUINO_PLATFORM
ft_void_t setup()
#endif
{
  /* Local variables */
  ft_uint8_t chipid;

  Ft_Gpu_HalInit_t halinit;

  halinit.TotalChannelNum = 1;
  Ft_Gpu_Hal_Init(&halinit);
  host.hal_config.channel_no = 0;
#ifdef MSVC_PLATFORM_SPI
  host.hal_config.spi_clockrate_khz = 12000; //in KHz
#endif
#ifdef ARDUINO_PLATFORM_SPI
  host.hal_config.spi_clockrate_khz = 4000; //in KHz
#endif
  Ft_Gpu_Hal_Open(&host);

  phost = &host;

  /* Do a power cycle for safer side */
  Ft_Gpu_Hal_Powercycle(phost);
  Ft_Gpu_Hal_Rd16(phost,RAM_G);
  /* Set the clk to external clock */
  Ft_Gpu_HostCommand(phost,FT_GPU_EXTERNAL_OSC);  
  Ft_Gpu_Hal_Sleep(10);


  /* Switch PLL output to 48MHz */
  Ft_Gpu_HostCommand(phost,FT_GPU_PLL_48M);  
  Ft_Gpu_Hal_Sleep(10);

  /* Do a core reset for safer side */
  Ft_Gpu_HostCommand(phost,FT_GPU_CORE_RESET);
  //Ft_Gpu_CoreReset(phost);

  /* Access address 0 to wake up the FT800 */
  Ft_Gpu_HostCommand(phost,FT_GPU_ACTIVE_M);  

  {
    //Read Register ID to check if FT800 is ready. 
    chipid = Ft_Gpu_Hal_Rd8(phost, REG_ID);
    while(chipid != 0x7C)
      chipid = Ft_Gpu_Hal_Rd8(phost, REG_ID);
#ifdef MSVC_PLATFORM
    printf("VC1 register ID after wake up %x\n",chipid);
#endif
  }
  /* Configuration of LCD display */
#ifdef SAMAPP_DISPLAY_QVGA	
  /* Values specific to QVGA LCD display */
  FT_DispWidth = 320;
  FT_DispHeight = 240;
  FT_DispHCycle =  408;
  FT_DispHOffset = 70;
  FT_DispHSync0 = 0;
  FT_DispHSync1 = 10;
  FT_DispVCycle = 263;
  FT_DispVOffset = 13;
  FT_DispVSync0 = 0;
  FT_DispVSync1 = 2;
  FT_DispPCLK = 8;
  FT_DispSwizzle = 2;
  FT_DispPCLKPol = 0;
#endif

  Ft_Gpu_Hal_Wr16(phost, REG_HCYCLE, FT_DispHCycle);
  Ft_Gpu_Hal_Wr16(phost, REG_HOFFSET, FT_DispHOffset);
  Ft_Gpu_Hal_Wr16(phost, REG_HSYNC0, FT_DispHSync0);
  Ft_Gpu_Hal_Wr16(phost, REG_HSYNC1, FT_DispHSync1);
  Ft_Gpu_Hal_Wr16(phost, REG_VCYCLE, FT_DispVCycle);
  Ft_Gpu_Hal_Wr16(phost, REG_VOFFSET, FT_DispVOffset);
  Ft_Gpu_Hal_Wr16(phost, REG_VSYNC0, FT_DispVSync0);
  Ft_Gpu_Hal_Wr16(phost, REG_VSYNC1, FT_DispVSync1);
  Ft_Gpu_Hal_Wr8(phost, REG_SWIZZLE, FT_DispSwizzle);
  Ft_Gpu_Hal_Wr8(phost, REG_PCLK_POL, FT_DispPCLKPol);
  Ft_Gpu_Hal_Wr8(phost, REG_PCLK,FT_DispPCLK);//after this display is visible on the LCD
  Ft_Gpu_Hal_Wr16(phost, REG_HSIZE, FT_DispWidth);
  Ft_Gpu_Hal_Wr16(phost, REG_VSIZE, FT_DispHeight);

  /* Initially fill both ping and pong buffer */
  Ft_Gpu_Hal_Wr8(phost, REG_GPIO_DIR,0xff);
  Ft_Gpu_Hal_Wr8(phost, REG_GPIO,0x0ff);
  /* Touch configuration - configure the resistance value to 1200 - this value is specific to customer requirement and derived by experiment */
  Ft_Gpu_Hal_Wr16(phost, REG_TOUCH_RZTHRESH,1200);



  /*It is optional to clear the screen here*/
  Ft_Gpu_Hal_WrMem(phost, RAM_DL,(ft_uint8_t *)FT_DLCODE_BOOTUP,sizeof(FT_DLCODE_BOOTUP));
  Ft_Gpu_Hal_Wr8(phost, REG_DLSWAP,DLSWAP_FRAME);

  Ft_Gpu_Hal_Sleep(1000);//Show the booting up screen. 
 
  pinMode(FT_SDCARD_CS, OUTPUT);
  digitalWrite(FT_SDCARD_CS, HIGH);
  delay(100);
  sd_present =  SD.begin(FT_SDCARD_CS);
  
  SPI.setClockDivider(SPI_CLOCK_DIV2);
  SPI.setBitOrder(MSBFIRST);
  SPI.setDataMode(SPI_MODE0);
  
  home_setup();
  Info(); 
  #ifdef ANDROID_METHOD
  menu();
  #endif 
  #ifdef LOOPBACK_METHOD
  menu_loopback();
  #endif
  #ifdef WIN8_METHOD
  menu_win8();
  #endif
  
    
#ifdef MSVC_PLATFORM
  return 0;
#endif
}

void loop()
{
}



/* Nothing beyond this */













  








